"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _case_form_fields = require("../case_form_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _template_fields = require("./template_fields");
var _use_cases_features = require("../../common/use_cases_features");
var _sync_alerts_toggle = require("../case_form_fields/sync_alerts_toggle");
var _connector = require("../case_form_fields/connector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormFieldsComponent = ({
  isSubmitting = false,
  connectors,
  currentConfiguration,
  isEditMode
}) => {
  const {
    isSyncAlertsEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    customFields: configurationCustomFields,
    templates
  } = currentConfiguration;
  const configurationTemplateTags = getTemplateTags(templates);
  const firstStep = (0, _react.useMemo)(() => ({
    title: i18n.TEMPLATE_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_template_fields.TemplateFields, {
      isLoading: isSubmitting,
      configurationTemplateTags: configurationTemplateTags
    })
  }), [isSubmitting, configurationTemplateTags]);
  const secondStep = (0, _react.useMemo)(() => ({
    title: i18n.CASE_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_case_form_fields.CaseFormFields, {
      configurationCustomFields: configurationCustomFields,
      isLoading: isSubmitting,
      setCustomFieldsOptional: true,
      isEditMode: isEditMode
    })
  }), [isSubmitting, configurationCustomFields, isEditMode]);
  const thirdStep = (0, _react.useMemo)(() => ({
    title: i18n.CASE_SETTINGS,
    children: /*#__PURE__*/_react.default.createElement(_sync_alerts_toggle.SyncAlertsToggle, {
      isLoading: isSubmitting
    })
  }), [isSubmitting]);
  const fourthStep = (0, _react.useMemo)(() => ({
    title: i18n.CONNECTOR_FIELDS,
    children: /*#__PURE__*/_react.default.createElement(_connector.Connector, {
      connectors: connectors,
      isLoading: isSubmitting,
      isLoadingConnectors: false
    })
  }), [connectors, isSubmitting]);
  const allSteps = (0, _react.useMemo)(() => [firstStep, secondStep, ...(isSyncAlertsEnabled ? [thirdStep] : []), fourthStep], [firstStep, secondStep, thirdStep, fourthStep, isSyncAlertsEnabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "key",
    component: _components.HiddenField
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: allSteps,
    "data-test-subj": 'template-creation-form-steps'
  }));
};
FormFieldsComponent.displayName = 'FormFields';
const FormFields = exports.FormFields = /*#__PURE__*/(0, _react.memo)(FormFieldsComponent);
const getTemplateTags = templates => (0, _lodash.uniq)(templates.map(template => {
  var _template$tags;
  return template !== null && template !== void 0 && (_template$tags = template.tags) !== null && _template$tags !== void 0 && _template$tags.length ? template.tags : [];
}).flat());