"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservableTypesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _delete_confirmation_modal = require("../../configure_cases/delete_confirmation_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservableTypesListComponent = props => {
  const {
    observableTypes,
    onDeleteObservableType,
    onEditObservableType
  } = props;
  const [selectedItem, setSelectedItem] = (0, _react.useState)(null);
  const onConfirm = (0, _react.useCallback)(() => {
    if (selectedItem) {
      onDeleteObservableType(selectedItem.key);
    }
    setSelectedItem(null);
  }, [onDeleteObservableType, setSelectedItem, selectedItem]);
  const onCancel = (0, _react.useCallback)(() => {
    setSelectedItem(null);
  }, []);
  const showModal = Boolean(selectedItem);
  return observableTypes.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    "data-test-subj": "observable-types-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, observableTypes.map(observableType => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: observableType.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    "data-test-subj": `observable-type-${observableType.key}`,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, observableType.label))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${observableType.key}-observable-type-edit`,
    "aria-label": `${observableType.key}-observable-type-edit`,
    iconType: "pencil",
    color: "primary",
    disabled: props.disabled,
    onClick: () => onEditObservableType(observableType.key)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `${observableType.key}-observable-type-delete`,
    "aria-label": `${observableType.key}-observable-type-delete`,
    iconType: "minusInCircle",
    color: "danger",
    disabled: props.disabled,
    onClick: () => setSelectedItem(observableType)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), showModal && selectedItem ? /*#__PURE__*/_react.default.createElement(_delete_confirmation_modal.DeleteConfirmationModal, {
    title: i18n.DELETE_OBSERVABLE_TYPE_TITLE(selectedItem.label),
    message: i18n.DELETE_OBSERVABLE_TYPE_DESCRIPTION,
    onCancel: onCancel,
    onConfirm: onConfirm
  }) : null)) : null;
};
ObservableTypesListComponent.displayName = 'ObservableTypesListComponent';
const ObservableTypesList = exports.ObservableTypesList = /*#__PURE__*/_react.default.memo(ObservableTypesListComponent);