"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** prevents search engine manipulation by noting the linked document is not trusted or endorsed by us */
const REL_NOFOLLOW = 'nofollow';
const MarkdownLinkComponent = ({
  disableLinks,
  href,
  target,
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: href
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: disableLinks ? undefined : href,
  "data-test-subj": "markdown-link",
  rel: `${REL_NOFOLLOW}`,
  target: "_blank"
}, children));
MarkdownLinkComponent.displayName = 'MarkdownLink';
const MarkdownLink = exports.MarkdownLink = /*#__PURE__*/(0, _react.memo)(MarkdownLinkComponent);