"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockFormWrapperComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MockFormWrapperComponent = ({
  children,
  fields = {}
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      fields
    }
  });
  const onClick = () => {
    form.submit();
  };
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "submit-form",
    onClick: onClick
  }));
};
exports.MockFormWrapperComponent = MockFormWrapperComponent;
MockFormWrapperComponent.displayName = 'MockFormWrapper';