"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApplication = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana_react = require("./kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isBehaviorSubjectObservable = observable => 'value' in observable;

/**
 * Checks if the observable is stateful and, in case, sets up `useObservable` with an initial value
 */
const useStatefulObservable = observable => {
  let initialValue;
  if (isBehaviorSubjectObservable(observable)) {
    initialValue = observable.value;
  }
  return (0, _useObservable.default)(observable, initialValue);
};
const useApplication = () => {
  var _applications$get$cat, _applications$get, _applications$get$cat2, _applications$get2;
  const {
    currentAppId$,
    applications$
  } = (0, _kibana_react.useKibana)().services.application;
  // retrieve the most recent value from the BehaviorSubject
  const appId = useStatefulObservable(currentAppId$);
  const applications = useStatefulObservable(applications$);
  const appTitle = appId ? (_applications$get$cat = applications === null || applications === void 0 ? void 0 : (_applications$get = applications.get(appId)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat2 = _applications$get.category) === null || _applications$get$cat2 === void 0 ? void 0 : _applications$get$cat2.label) !== null && _applications$get$cat !== void 0 ? _applications$get$cat : applications === null || applications === void 0 ? void 0 : (_applications$get2 = applications.get(appId)) === null || _applications$get2 === void 0 ? void 0 : _applications$get2.title : undefined;
  return {
    appId,
    appTitle
  };
};
exports.useApplication = useApplication;