"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseUserActionWithoutReferenceIdsRt = exports.CaseUserActionInjectedIdsRt = exports.CaseUserActionInjectedDeprecatedIdsRt = exports.CaseUserActionBasicRt = void 0;
Object.defineProperty(exports, "StatusUserActionRt", {
  enumerable: true,
  get: function () {
    return _v13.StatusUserActionRt;
  }
});
Object.defineProperty(exports, "UserActionActions", {
  enumerable: true,
  get: function () {
    return _v2.UserActionActions;
  }
});
exports.UserActionAttributesRt = void 0;
Object.defineProperty(exports, "UserActionTypes", {
  enumerable: true,
  get: function () {
    return _v2.UserActionTypes;
  }
});
exports.UserActionsRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../user/v1");
var _v2 = require("./action/v1");
var _v3 = require("./assignees/v1");
var _v4 = require("./category/v1");
var _v5 = require("./comment/v1");
var _v6 = require("./connector/v1");
var _v7 = require("./create_case/v1");
var _v8 = require("./delete_case/v1");
var _v9 = require("./description/v1");
var _v10 = require("./pushed/v1");
var _v11 = require("./settings/v1");
var _v12 = require("./severity/v1");
var _v13 = require("./status/v1");
var _v14 = require("./tags/v1");
var _v15 = require("./title/v1");
var _v16 = require("./custom_fields/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserActionCommonAttributesRt = rt.strict({
  created_at: rt.string,
  created_by: _v.UserRt,
  owner: rt.string,
  action: _v2.UserActionActionsRt
});

/**
 * This should only be used for the getAll route and it should be removed when the route is removed
 * @deprecated use CaseUserActionInjectedIdsRt instead
 */
const CaseUserActionInjectedDeprecatedIdsRt = exports.CaseUserActionInjectedDeprecatedIdsRt = rt.strict({
  action_id: rt.string,
  case_id: rt.string,
  comment_id: rt.union([rt.string, rt.null])
});
const CaseUserActionInjectedIdsRt = exports.CaseUserActionInjectedIdsRt = rt.strict({
  comment_id: rt.union([rt.string, rt.null])
});
const BasicUserActionsRt = rt.union([_v9.DescriptionUserActionRt, _v14.TagsUserActionRt, _v15.TitleUserActionRt, _v11.SettingsUserActionRt, _v13.StatusUserActionRt, _v12.SeverityUserActionRt, _v3.AssigneesUserActionRt, _v8.DeleteCaseUserActionRt, _v4.CategoryUserActionRt, _v16.CustomFieldsUserActionRt]);
const CommonUserActionsWithIdsRt = rt.union([BasicUserActionsRt, _v5.CommentUserActionRt]);
const CommonUserActionsWithoutIdsRt = rt.union([BasicUserActionsRt, _v5.CommentUserActionWithoutIdsRt]);
const UserActionPayloadRt = rt.union([CommonUserActionsWithIdsRt, _v7.CreateCaseUserActionRt, _v6.ConnectorUserActionRt, _v10.PushedUserActionRt]);
const UserActionsWithoutIdsRt = rt.union([CommonUserActionsWithoutIdsRt, _v7.CreateCaseUserActionWithoutConnectorIdRt, _v6.ConnectorUserActionWithoutConnectorIdRt, _v10.PushedUserActionWithoutConnectorIdRt]);
const CaseUserActionBasicRt = exports.CaseUserActionBasicRt = rt.intersection([UserActionPayloadRt, UserActionCommonAttributesRt]);
const CaseUserActionWithoutReferenceIdsRt = exports.CaseUserActionWithoutReferenceIdsRt = rt.intersection([UserActionsWithoutIdsRt, UserActionCommonAttributesRt]);

/**
 * This includes the comment_id but not the action_id or case_id
 */
const UserActionAttributesRt = exports.UserActionAttributesRt = rt.intersection([CaseUserActionBasicRt, CaseUserActionInjectedIdsRt]);
const UserActionRt = rt.intersection([UserActionAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
const UserActionsRt = exports.UserActionsRt = rt.array(UserActionRt);

/**
 * User actions
 */