"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSingleFunctionChain = parseSingleFunctionChain;
var _lodash = require("lodash");
var _interpreter = require("@kbn/interpreter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function parseSingleFunctionChain(filterString) {
  const ast = (0, _interpreter.fromExpression)(filterString);

  // Check if the current column is what we expect it to be. If the user changes column this will be called again,
  // but we don't want to run setFilter() unless we have to because it will cause a data refresh
  const name = (0, _lodash.get)(ast, 'chain[0].function');
  if (!name) {
    throw new Error('Could not find function name in chain');
  }
  const args = (0, _lodash.mapValues)((0, _lodash.get)(ast, 'chain[0].arguments'), val => {
    // TODO Check for literals only
    return (0, _lodash.map)(val, 'value');
  });
  return {
    name,
    args
  };
}