"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimeStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../i18n/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getDownloadLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.runtimeStep.downloadLabel', {
    defaultMessage: 'Download runtime'
  }),
  getStepDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.runtimeStep.description', {
    defaultMessage: 'In order to render a Shareable Workpad, you also need to include the {CANVAS} Shareable Workpad Runtime. You can skip this step if the runtime is already included on your website.',
    values: {
      CANVAS: _constants.CANVAS
    }
  })
};
const RuntimeStep = ({
  onDownload
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getStepDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: () => {
    onDownload('shareRuntime');
  },
  size: "s"
}, strings.getDownloadLabel()));
exports.RuntimeStep = RuntimeStep;