"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatByKey = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getBlankLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filter.blankTypeLabel', {
    defaultMessage: '(Blank)'
  }),
  getExactlyFilterTypeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.defaultFilter.typeLabel', {
    defaultMessage: 'Dropdown'
  }),
  getTimeFilterTypeLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.timeFilter.typeLabel', {
    defaultMessage: 'Time'
  }),
  getWithoutGroupLabel: () => _i18n.i18n.translate('xpack.canvas.workpadFilters.filters_group.withoutGroup', {
    defaultMessage: 'Without group'
  })
};
const formatType = type => {
  var _types$type;
  const types = {
    exactly: strings.getExactlyFilterTypeLabel(),
    time: strings.getTimeFilterTypeLabel()
  };
  return typeof type === 'string' ? (_types$type = types[type]) !== null && _types$type !== void 0 ? _types$type : type : null;
};
const formatters = {
  type: formatType
};
const formatByKey = key => formatters[key];
exports.formatByKey = formatByKey;