"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Filter = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderElement = (Component, {
  updateFilter,
  ...props
}) => {
  return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    onChange: updateFilter
  }));
};
const Filter = ({
  filter,
  ...restProps
}) => {
  const filterView = Object.values(filter).map(filterValue => {
    const description = filterValue.component ? renderElement(filterValue.component, {
      value: filterValue.formattedValue,
      ...restProps
    }) : filterValue.formattedValue;
    return {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h4", null, filterValue.label)),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, description)
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    columnWidths: [3, 7],
    className: "workpadFilter",
    compressed: true,
    listItems: filterView,
    titleProps: {
      className: 'eui-textBreakWord'
    },
    descriptionProps: {
      className: 'eui-textBreakWord'
    }
  }));
};
exports.Filter = Filter;