"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VarConfig = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _edit_var = require("./edit_var");
var _delete_var = require("./delete_var");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var PanelMode = /*#__PURE__*/function (PanelMode) {
  PanelMode[PanelMode["List"] = 0] = "List";
  PanelMode[PanelMode["Edit"] = 1] = "Edit";
  PanelMode[PanelMode["Delete"] = 2] = "Delete";
  return PanelMode;
}(PanelMode || {});
const typeToToken = {
  number: 'tokenNumber',
  boolean: 'tokenBoolean',
  string: 'tokenString'
};
const strings = {
  getAddButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.addButtonLabel', {
    defaultMessage: 'Add a variable'
  }),
  getAddTooltipLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.addTooltipLabel', {
    defaultMessage: 'Add a variable'
  }),
  getCopyActionButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.copyActionButtonLabel', {
    defaultMessage: 'Copy snippet'
  }),
  getCopyActionTooltipLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.copyActionTooltipLabel', {
    defaultMessage: 'Copy variable syntax to clipboard'
  }),
  getDeleteActionButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.deleteActionButtonLabel', {
    defaultMessage: 'Delete variable'
  }),
  getEditActionButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.editActionButtonLabel', {
    defaultMessage: 'Edit variable'
  }),
  getEmptyDescription: () => _i18n.i18n.translate('xpack.canvas.varConfig.emptyDescription', {
    defaultMessage: 'This workpad has no variables currently. You may add variables to store and edit common values. These variables can then be used in elements or within the expression editor.'
  }),
  getTableNameLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.tableNameLabel', {
    defaultMessage: 'Name'
  }),
  getTableTypeLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.tableTypeLabel', {
    defaultMessage: 'Type'
  }),
  getTableValueLabel: () => _i18n.i18n.translate('xpack.canvas.varConfig.tableValueLabel', {
    defaultMessage: 'Value'
  }),
  getTitle: () => _i18n.i18n.translate('xpack.canvas.varConfig.titleLabel', {
    defaultMessage: 'Variables'
  }),
  getTitleTooltip: () => _i18n.i18n.translate('xpack.canvas.varConfig.titleTooltip', {
    defaultMessage: 'Add variables to store and edit common values'
  })
};
const VarConfig = ({
  variables,
  onCopyVar,
  onDeleteVar,
  onAddVar,
  onEditVar
}) => {
  const [panelMode, setPanelMode] = (0, _react.useState)(PanelMode.List);
  const [selectedVar, setSelectedVar] = (0, _react.useState)(null);
  const selectAndEditVar = v => {
    setSelectedVar(v);
    setPanelMode(PanelMode.Edit);
  };
  const selectAndDeleteVar = v => {
    setSelectedVar(v);
    setPanelMode(PanelMode.Delete);
  };
  const actions = [{
    type: 'icon',
    name: strings.getCopyActionButtonLabel(),
    description: strings.getCopyActionTooltipLabel(),
    icon: 'copyClipboard',
    onClick: onCopyVar,
    isPrimary: true
  }, {
    type: 'icon',
    name: strings.getEditActionButtonLabel(),
    description: '',
    icon: 'pencil',
    onClick: selectAndEditVar
  }, {
    type: 'icon',
    name: strings.getDeleteActionButtonLabel(),
    description: '',
    icon: 'trash',
    color: 'danger',
    onClick: selectAndDeleteVar
  }];
  const varColumns = [{
    field: 'type',
    name: strings.getTableTypeLabel(),
    sortable: true,
    render: (varType, _v) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        iconType: typeToToken[varType]
      });
    },
    width: '50px'
  }, {
    field: 'name',
    name: strings.getTableNameLabel(),
    sortable: true
  }, {
    field: 'value',
    name: strings.getTableValueLabel(),
    sortable: true,
    truncateText: true,
    render: (value, _v) => {
      return '' + value;
    }
  }, {
    actions,
    width: '60px'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `canvasSidebar__expandable canvasVarConfig__container ${panelMode !== PanelMode.List ? 'canvasVarConfig-isEditMode' : ''}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasVarConfig__innerContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion-variables",
    className: "canvasVarConfig__listView canvasSidebar__accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: strings.getTitleTooltip(),
      position: "left",
      className: "canvasArg__tooltip"
    }, /*#__PURE__*/_react.default.createElement("span", null, strings.getTitle())),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: strings.getAddTooltipLabel()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "primary",
      iconType: "plusInCircle",
      "aria-label": strings.getAddTooltipLabel(),
      onClick: () => {
        setSelectedVar(null);
        setPanelMode(PanelMode.Edit);
      }
    }))
  }, variables.length !== 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "canvasVarConfig__list",
    items: variables,
    columns: varColumns,
    pagination: false,
    sorting: true,
    compressed: true
  })), variables.length === 0 && /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, strings.getEmptyDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "plusInCircle",
    onClick: () => setPanelMode(PanelMode.Edit)
  }, strings.getAddButtonLabel()))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasVarConfig__editView canvasSidebar__accordion"
  }, panelMode === PanelMode.Edit && /*#__PURE__*/_react.default.createElement(_edit_var.EditVar, {
    variables: variables,
    selectedVar: selectedVar,
    onSave: newVar => {
      if (!selectedVar) {
        onAddVar(newVar);
      } else {
        onEditVar(selectedVar, newVar);
      }
      setSelectedVar(null);
      setPanelMode(PanelMode.List);
    },
    onCancel: () => {
      setSelectedVar(null);
      setPanelMode(PanelMode.List);
    }
  }), panelMode === PanelMode.Delete && selectedVar && /*#__PURE__*/_react.default.createElement(_delete_var.DeleteVar, {
    selectedVar: selectedVar,
    onDelete: v => {
      onDeleteVar(v);
      setSelectedVar(null);
      setPanelMode(PanelMode.List);
    },
    onCancel: () => {
      setSelectedVar(null);
      setPanelMode(PanelMode.List);
    }
  }))));
};
exports.VarConfig = VarConfig;