"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loading = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _hex_to_rgb = require("../../../common/lib/hex_to_rgb");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Loading = ({
  animated = false,
  text = '',
  backgroundColor = '#000000'
}) => {
  if (animated) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasLoading"
    }, text && /*#__PURE__*/_react.default.createElement("span", null, text, "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    }));
  }
  const rgb = (0, _hex_to_rgb.hexToRgb)(backgroundColor);
  let color = 'text';
  if (rgb && (0, _eui.isColorDark)(rgb[0], rgb[1], rgb[2])) {
    color = 'ghost';
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasLoading"
  }, text && /*#__PURE__*/_react.default.createElement("span", null, text, "\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: color,
    type: "clock"
  }));
};
exports.Loading = Loading;
Loading.propTypes = {
  animated: _propTypes.default.bool,
  backgroundColor: _propTypes.default.string,
  text: _propTypes.default.string
};
Loading.defaultProps = {
  animated: false,
  backgroundColor: '#000000',
  text: ''
};