"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldsSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESFieldsSelect = ({
  selected = [],
  fields = [],
  onChange,
  onFocus,
  onBlur
}) => {
  const options = fields.map(value => ({
    label: value
  }));
  const selectedOptions = selected.map(value => ({
    label: value
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedOptions,
    options: options,
    onChange: values => onChange(values.map(({
      label
    }) => label)),
    className: "canvasFieldsSelect",
    onFocus: onFocus,
    onBlur: onBlur,
    compressed: true
  });
};
exports.ESFieldsSelect = ESFieldsSelect;