"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTraceCorrelation = getTraceCorrelation;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apmTypes = require("@kbn/apm-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTraceCorrelation({
  apmEventClient,
  start,
  end,
  traceId,
  sourceNode,
  destinationNode
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9, _response$aggregation10;
  const response = await apmEventClient.search('diagnostics_get_trace_correlation', {
    apm: {
      events: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
    },
    body: {
      track_total_hits: true,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apmTypes.TRACE_ID, traceId)]
        }
      },
      aggs: {
        source_node_traces: {
          filter: {
            term: {
              [_apmTypes.SERVICE_NAME]: sourceNode
            }
          },
          aggs: {
            sample_docs: {
              top_hits: {
                size: 5
              }
            }
          }
        },
        destination_node_traces: {
          filter: {
            term: {
              [_apmTypes.SERVICE_NAME]: destinationNode
            }
          },
          aggs: {
            sample_docs: {
              top_hits: {
                size: 5
              }
            }
          }
        }
      }
    }
  });
  const sourceNodeCount = ((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : (_response$aggregation2 = _response$aggregation.source_node_traces) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.sample_docs) === null || _response$aggregation3 === void 0 ? void 0 : (_response$aggregation4 = _response$aggregation3.hits) === null || _response$aggregation4 === void 0 ? void 0 : (_response$aggregation5 = _response$aggregation4.total) === null || _response$aggregation5 === void 0 ? void 0 : _response$aggregation5.value) || 0;
  const destinationNodeCount = ((_response$aggregation6 = response.aggregations) === null || _response$aggregation6 === void 0 ? void 0 : (_response$aggregation7 = _response$aggregation6.destination_node_traces) === null || _response$aggregation7 === void 0 ? void 0 : (_response$aggregation8 = _response$aggregation7.sample_docs) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.hits) === null || _response$aggregation9 === void 0 ? void 0 : (_response$aggregation10 = _response$aggregation9.total) === null || _response$aggregation10 === void 0 ? void 0 : _response$aggregation10.value) || 0;
  return {
    foundInSourceNode: sourceNodeCount > 0,
    foundInDestinationNode: destinationNodeCount > 0,
    foundInBothNodes: destinationNodeCount > 0 && sourceNodeCount > 0,
    sourceNodeDocumentCount: sourceNodeCount,
    destinationNodeDocumentCount: destinationNodeCount,
    rawResponse: response
  };
}