"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.goVariables = exports.goLineNumbers = exports.goHighlightLang = exports.go = void 0;
var _i18n = require("@kbn/i18n");
var _shared_hints = require("./shared_hints");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const goVariables = exports.goVariables = {
  apmServiceName: 'ELASTIC_APM_SERVICE_NAME',
  secretToken: 'ELASTIC_APM_SECRET_TOKEN',
  apmServerUrl: 'ELASTIC_APM_SERVER_URL',
  apmEnvironment: 'ELASTIC_APM_ENVIRONMENT'
};
const goHighlightLang = exports.goHighlightLang = 'go';
const goServiceNameHint = _i18n.i18n.translate('xpack.apm.tutorial.goClient.configure.commands.usedExecutableNameComment', {
  defaultMessage: 'If not specified, the executable name will be used.'
});
const goLineNumbers = exports.goLineNumbers = {
  start: 1,
  highlight: '2, 4, 6, 8',
  annotations: {
    2: `${_shared_hints.serviceNameHint} ${goServiceNameHint}`,
    4: _shared_hints.secretTokenHint,
    6: _shared_hints.serverUrlHint,
    8: _shared_hints.serviceEnvironmentHint
  }
};
const go = exports.go = `# ${_i18n.i18n.translate('xpack.apm.tutorial.goClient.configure.commands.initializeUsingEnvironmentVariablesComment', {
  defaultMessage: 'Initialize using environment variables:'
})}
export ${goVariables.apmServiceName}={{{apmServiceName}}}

export ${goVariables.secretToken}={{{secretToken}}}

export ${goVariables.apmServerUrl}={{{apmServerUrl}}}

export ${goVariables.apmEnvironment}={{{apmEnvironment}}}
`;