"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentConfigInstructions = AgentConfigInstructions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _opentelemetry_instructions = require("./opentelemetry_instructions");
var _get_apm_agent_commands = require("./commands/get_apm_agent_commands");
var _agent_config_table = require("./agent_config_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AgentConfigInstructions({
  variantId,
  apmServerUrl,
  secretToken
}) {
  const defaultValues = {
    apmServiceName: 'my-service-name',
    apmEnvironment: 'my-environment'
  };
  if (variantId === 'openTelemetry') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_opentelemetry_instructions.OpenTelemetryInstructions, {
      apmServerUrl: apmServerUrl,
      secretToken: secretToken
    }));
  }
  const commands = (0, _get_apm_agent_commands.getApmAgentCommands)({
    variantId,
    policyDetails: {
      apmServerUrl,
      secretToken
    },
    defaultValues
  });
  const variables = (0, _get_apm_agent_commands.getApmAgentVariables)(variantId);
  const lineNumbers = (0, _get_apm_agent_commands.getApmAgentLineNumbers)(variantId);
  const highlightLang = (0, _get_apm_agent_commands.getApmAgentHighlightLang)(variantId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_agent_config_table.AgentConfigurationTable, {
    variables: variables,
    data: {
      apmServerUrl,
      secretToken,
      ...defaultValues
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    copyAriaLabel: _i18n.i18n.translate('xpack.apm.tutorial.apmAgents.agentConfigurationInstructions.copyAriaLabel', {
      defaultMessage: 'Copy {variantId} agent configuration code',
      values: {
        variantId
      }
    }),
    language: highlightLang || 'bash',
    "data-test-subj": "commands",
    lineNumbers: lineNumbers
  }, commands));
}