"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDetailsTabs = TransactionDetailsTabs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _ebtTools = require("@kbn/ebt-tools");
var _maybe = require("../../../../common/utils/maybe");
var _use_url_params = require("../../../context/url_params_context/use_url_params");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_sample_chart_selection = require("../../../hooks/use_sample_chart_selection");
var _use_transaction_trace_samples_fetcher = require("../../../hooks/use_transaction_trace_samples_fetcher");
var _url_helpers = require("../../shared/links/url_helpers");
var _failed_transactions_correlations_tab = require("./failed_transactions_correlations_tab");
var _latency_correlations_tab = require("./latency_correlations_tab");
var _profiling_tab = require("./profiling_tab");
var _trace_samples_tab = require("./trace_samples_tab");
var _use_profiling_integration_setting = require("../../../hooks/use_profiling_integration_setting");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _agent_name = require("../../../../common/agent_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDetailsTabs() {
  var _availableTabs$find;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    agentName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isTransactionProfilingEnabled = (0, _use_profiling_integration_setting.useTransactionProfilingSetting)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const availableTabs = (0, _react.useMemo)(() => {
    const tabs = [_trace_samples_tab.traceSamplesTab, _latency_correlations_tab.latencyCorrelationsTab, _failed_transactions_correlations_tab.failedTransactionsCorrelationsTab];
    if (isTransactionProfilingEnabled && (0, _agent_name.isJavaAgentName)(agentName)) {
      tabs.push(_profiling_tab.profilingTab);
    }
    return tabs;
  }, [agentName, isTransactionProfilingEnabled]);
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const history = (0, _reactRouterDom.useHistory)();
  const [currentTab, setCurrentTab] = (0, _react.useState)(_trace_samples_tab.traceSamplesTab.key);
  const {
    component: TabContent
  } = (_availableTabs$find = availableTabs.find(tab => tab.key === currentTab)) !== null && _availableTabs$find !== void 0 ? _availableTabs$find : _trace_samples_tab.traceSamplesTab;
  const {
    environment,
    kuery,
    transactionName,
    rangeFrom,
    rangeTo
  } = query;
  const traceSamplesFetchResult = (0, _use_transaction_trace_samples_fetcher.useTransactionTraceSamplesFetcher)({
    transactionName,
    kuery,
    environment,
    rangeFrom,
    rangeTo
  });
  const {
    sampleRangeFrom,
    sampleRangeTo,
    transactionId,
    traceId
  } = urlParams;
  const {
    clearChartSelection,
    selectSampleFromChartSelection
  } = (0, _use_sample_chart_selection.useSampleChartSelection)();

  // When filtering in either the latency correlations or failed transactions correlations tab,
  // scroll to the top of the page and switch to the 'Trace samples' tab to trigger a refresh.
  const traceSamplesTabKey = _trace_samples_tab.traceSamplesTab.key;
  const onFilter = (0, _react.useCallback)(() => {
    // Scroll to the top of the page
    window.scrollTo(0, 0);
    // Switch back to the 'trace samples' tab
    setCurrentTab(traceSamplesTabKey);
  }, [traceSamplesTabKey]);
  (0, _react.useEffect)(() => {
    if (traceSamplesFetchResult.status === _use_fetcher.FETCH_STATUS.SUCCESS) {
      var _traceSamplesFetchRes, _traceSamplesFetchRes2, _traceSamplesFetchRes3;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'traceDocsTotal',
          value1: (_traceSamplesFetchRes = (_traceSamplesFetchRes2 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes2 === void 0 ? void 0 : (_traceSamplesFetchRes3 = _traceSamplesFetchRes2.traceSamples) === null || _traceSamplesFetchRes3 === void 0 ? void 0 : _traceSamplesFetchRes3.length) !== null && _traceSamplesFetchRes !== void 0 ? _traceSamplesFetchRes : 0
        }
      });
    }
  }, [traceSamplesFetchResult, onPageReady, rangeFrom, rangeTo]);
  (0, _react.useEffect)(() => {
    var _traceSamplesFetchRes4;
    const selectedSample = (_traceSamplesFetchRes4 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes4 === void 0 ? void 0 : _traceSamplesFetchRes4.traceSamples.find(sample => sample.transactionId === transactionId && sample.traceId === traceId);
    if (traceSamplesFetchResult.status === _use_fetcher.FETCH_STATUS.SUCCESS && !selectedSample) {
      var _traceSamplesFetchRes5;
      // selected sample was not found. select a new one:
      const preferredSample = (0, _maybe.maybe)((_traceSamplesFetchRes5 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes5 === void 0 ? void 0 : _traceSamplesFetchRes5.traceSamples[0]);
      history.replace({
        ...history.location,
        search: (0, _url_helpers.fromQuery)({
          ...(0, _lodash.omit)((0, _url_helpers.toQuery)(history.location.search), ['traceId', 'transactionId']),
          ...{
            traceId: preferredSample === null || preferredSample === void 0 ? void 0 : preferredSample.traceId,
            transactionId: preferredSample === null || preferredSample === void 0 ? void 0 : preferredSample.transactionId
          }
        })
      });
    }
  }, [history, transactionId, traceId, traceSamplesFetchResult]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, availableTabs.map(({
    dataTestSubj,
    key,
    label
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": dataTestSubj,
    key: key,
    isSelected: key === currentTab,
    onClick: () => {
      setCurrentTab(key);
    }
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(TabContent, {
    clearChartSelection,
    onFilter,
    sampleRangeFrom,
    sampleRangeTo,
    selectSampleFromChartSelection,
    traceSamplesFetchResult
  })));
}