"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceSearchBox = TraceSearchBox;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _trace_explorer = require("../../../../../common/trace_explorer");
var _use_adhoc_apm_data_view = require("../../../../hooks/use_adhoc_apm_data_view");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _monaco_code_editor = require("../../../shared/monaco_code_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const options = [{
  value: _trace_explorer.TraceSearchType.kql,
  text: _i18n.i18n.translate('xpack.apm.traceSearchBox.traceSearchTypeKql', {
    defaultMessage: 'KQL'
  })
}, {
  value: _trace_explorer.TraceSearchType.eql,
  text: _i18n.i18n.translate('xpack.apm.traceSearchBox.traceSearchTypeEql', {
    defaultMessage: 'EQL'
  })
}];
function TraceSearchBox({
  query,
  onQueryChange,
  onQueryCommit,
  loading
}) {
  const {
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, query.type === _trace_explorer.TraceSearchType.eql ? /*#__PURE__*/_react.default.createElement(_monaco_code_editor.EQLCodeEditor, {
    value: query.query,
    onChange: value => {
      onQueryChange({
        ...query,
        query: value
      });
    }
  }) : /*#__PURE__*/_react.default.createElement("form", null, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    disableLanguageSwitcher: true,
    indexPatterns: dataView ? [dataView] : [],
    query: {
      query: query.query,
      language: 'kuery'
    },
    onSubmit: () => {
      onQueryCommit();
    },
    disableAutoFocus: true,
    submitOnBlur: true,
    isClearable: true,
    onChange: e => {
      var _e$query;
      onQueryChange({
        ...query,
        query: String((_e$query = e.query) !== null && _e$query !== void 0 ? _e$query : '')
      });
    },
    appName: _i18n.i18n.translate('xpack.apm.traceExplorer.appName', {
      defaultMessage: 'APM'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmTraceSearchBoxSelect",
    id: "select-query-language",
    value: query.type,
    onChange: e => {
      onQueryChange({
        query: '',
        type: e.target.value
      });
    },
    options: options
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      alignSelf: 'flex-end'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "apmTraceSearchBoxSearchButton",
    isLoading: loading,
    onClick: () => {
      onQueryCommit();
    },
    iconType: "search",
    style: {
      width: '100px'
    }
  }, _i18n.i18n.translate('xpack.apm.traceSearchBox.refreshButton', {
    defaultMessage: 'Search'
  }))))));
}