"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutPrompt = TimeoutPrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimeoutPrompt({
  isGlobalServiceMap
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "subdued",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPromptTitle', {
      defaultMessage: 'Service Map timeout'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPromptDescription', {
      defaultMessage: `Timed out while fetching data for service map. Limit the scope by selecting a smaller time range, or use configuration setting ''{configName}'' with a reduced value.`,
      values: {
        configName: isGlobalServiceMap ? 'xpack.apm.serviceMapFingerprintGlobalBucketSize' : 'xpack.apm.serviceMapFingerprintBucketSize'
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(ApmSettingsDocLink, null)
  });
}
function ApmSettingsDocLink() {
  const {
    docLinks
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmApmSettingsDocLinkLearnMoreAboutApmSettingsInTheDocsLink",
    href: docLinks.links.apm.kibanaSettings
  }, _i18n.i18n.translate('xpack.apm.serviceMap.timeoutPrompt.docsLink', {
    defaultMessage: 'Learn more about APM settings in the docs'
  }));
}