"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingHostsFlamegraph = ProfilingHostsFlamegraph;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../common/es_fields/apm");
var _kuery_utils = require("../../../../common/utils/kuery_utils");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _flamegraph = require("../../shared/charts/flamegraph");
var _flamegraph_link = require("../../shared/profiling/flamegraph/flamegraph_link");
var _filter_warning = require("./filter_warning");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingHostsFlamegraph({
  start,
  end,
  serviceName,
  environment,
  dataSource,
  kuery,
  rangeFrom,
  rangeTo
}) {
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (dataSource) {
      return callApmApi('GET /internal/apm/services/{serviceName}/profiling/hosts/flamegraph', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end,
            environment,
            documentType: dataSource.documentType,
            rollupInterval: dataSource.rollupInterval,
            kuery
          }
        }
      });
    }
  }, [dataSource, serviceName, start, end, environment, kuery]);
  const profilingKueryFilter = data !== null && data !== void 0 && data.containerIds && data.containerIds.length > 0 ? (0, _kuery_utils.toKueryFilterFormat)(_apm.CONTAINER_ID, (data === null || data === void 0 ? void 0 : data.containerIds) || []) : (0, _kuery_utils.toKueryFilterFormat)(_apm.HOST_NAME, (data === null || data === void 0 ? void 0 : data.hostNames) || []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_filter_warning.FilterWarning, {
    containerIds: data === null || data === void 0 ? void 0 : data.containerIds,
    hostNames: data === null || data === void 0 ? void 0 : data.hostNames
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_flamegraph_link.ProfilingFlamegraphLink, {
    kuery: (0, _kuery_utils.mergeKueries)([`(${profilingKueryFilter})`, kuery]),
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    justifyContent: "flexEnd"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_flamegraph.FlamegraphChart, {
    data: data === null || data === void 0 ? void 0 : data.flamegraph,
    status: status
  }));
}