"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serverlessInstructions = serverlessInstructions;
var _i18n = require("@kbn/i18n");
var _instruction_variants = require("./instruction_variants");
var _instructions = require("./instructions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function serverlessInstructions({
  baseUrl,
  config,
  checkAgentStatus,
  agentStatus,
  agentStatusLoading
}, apiKeyLoading, apiKeyDetails, createAgentKey) {
  const {
    apiKey,
    error,
    errorMessage
  } = apiKeyDetails;
  const displayApiKeySuccessCallout = Boolean(apiKey) && !error;
  const displayApiKeyErrorCallout = error && Boolean(errorMessage);
  const commonOptions = {
    baseUrl,
    apmServerUrl: `${config.managedServiceUrl}:443`,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading,
    apiKeyDetails: {
      ...apiKeyDetails,
      displayApiKeySuccessCallout,
      displayApiKeyErrorCallout,
      createAgentKey,
      createApiKeyLoading: apiKeyLoading
    }
  };
  return {
    title: _i18n.i18n.translate('xpack.apm.tutorial.apmAgents.title', {
      defaultMessage: 'APM Agents'
    }),
    instructionVariants: [{
      id: _instruction_variants.INSTRUCTION_VARIANT.NODE,
      instructions: (0, _instructions.createNodeAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.DJANGO,
      instructions: (0, _instructions.createDjangoAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.FLASK,
      instructions: (0, _instructions.createFlaskAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.RAILS,
      instructions: (0, _instructions.createRailsAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.RACK,
      instructions: (0, _instructions.createRackAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.GO,
      instructions: (0, _instructions.createGoAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.JAVA,
      instructions: (0, _instructions.createJavaAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.DOTNET,
      instructions: (0, _instructions.createDotNetAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.PHP,
      instructions: (0, _instructions.createPhpAgentInstructions)(commonOptions)
    }, {
      id: _instruction_variants.INSTRUCTION_VARIANT.OPEN_TELEMETRY,
      instructions: (0, _instructions.createOpenTelemetryAgentInstructions)(commonOptions)
    }]
  };
}