"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileErrorCrashesOverview = MobileErrorCrashesOverview;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _tabs = require("./tabs/tabs");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _url_helpers = require("../../../shared/links/url_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MobileErrorCrashesOverview() {
  const {
    query: {
      mobileErrorTabId = _tabs.MobileErrorTabIds.ERRORS
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/errors-and-crashes');
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    onTabClick: nextTab => {
      (0, _url_helpers.push)(history, {
        query: {
          mobileErrorTabId: nextTab
        }
      });
    },
    mobileErrorTabId: mobileErrorTabId
  })));
}