"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionTypeSelect = TransactionTypeSelect;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionTypeSelect({
  transactionType,
  transactionTypes,
  onChange
}) {
  const options = transactionTypes.map(t => ({
    text: t,
    value: t
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    style: {
      minWidth: 160
    },
    compressed: true,
    "data-test-subj": "alertingFilterTransactionType",
    prepend: _i18n.i18n.translate('xpack.apm.alertingVisualizations.transactionType.prepend', {
      defaultMessage: 'Transaction Type'
    }),
    onChange: event => onChange(event.target.value),
    options: options,
    value: transactionType
  });
}