"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLineWriter = exports.LineWriter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const INDENT_LENGTH = 2;
const INDENT = ''.padStart(INDENT_LENGTH);
class LineWriter {
  constructor(separator = '\n') {
    (0, _defineProperty2.default)(this, "_indent", '');
    (0, _defineProperty2.default)(this, "_lines", []);
    (0, _defineProperty2.default)(this, "_separator", void 0);
    this._indent = '';
    this._lines = [];
    this._separator = separator;
  }
  addLine(line) {
    this._lines.push(`${this._indent}${line}`);
  }
  addLineAndIndent(line) {
    this._lines.push(`${this._indent}${line}`);
    this._indent = `${this._indent}${INDENT}`;
  }
  dedentAndAddLine(line) {
    this._indent = this._indent.substr(INDENT_LENGTH);
    this._lines.push(`${this._indent}${line}`);
  }
  indent() {
    this._indent = `${this._indent}${INDENT}`;
  }
  dedent() {
    this._indent = this._indent.substr(INDENT_LENGTH);
  }
  getContent() {
    return this._lines.join(this._separator);
  }
}
exports.LineWriter = LineWriter;
const createLineWriter = (separator = '\n') => new LineWriter(separator);
exports.createLineWriter = createLineWriter;