"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsToExcludeFromRevisionUpdates = exports.fieldsToExcludeFromPublicApi = exports.RulesClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tags = require("../application/rule/methods/tags");
var _parse_duration = require("../../common/parse_duration");
var _clone = require("../application/rule/methods/clone");
var _create = require("../application/rule/methods/create");
var _update = require("../application/rule/methods/update");
var _snooze = require("../application/rule/methods/snooze");
var _unsnooze = require("../application/rule/methods/unsnooze");
var _get = require("../application/rule/methods/get");
var _bulk_get = require("../application/rule/methods/bulk_get");
var _resolve = require("../application/rule/methods/resolve");
var _get_alert_state = require("./methods/get_alert_state");
var _get_alert_summary = require("./methods/get_alert_summary");
var _get_execution_log = require("./methods/get_execution_log");
var _get_action_error_log = require("./methods/get_action_error_log");
var _get_execution_kpi = require("./methods/get_execution_kpi");
var _find = require("../application/rule/methods/find");
var _aggregate = require("../application/rule/methods/aggregate");
var _delete = require("../application/rule/methods/delete");
var _bulk_delete = require("../application/rule/methods/bulk_delete");
var _bulk_disable = require("../application/rule/methods/bulk_disable");
var _bulk_edit_rules = require("../application/rule/methods/bulk_edit/bulk_edit_rules");
var _bulk_enable = require("../application/rule/methods/bulk_enable");
var _enable_rule = require("../application/rule/methods/enable_rule/enable_rule");
var _update_rule_api_key = require("../application/rule/methods/update_api_key/update_rule_api_key");
var _disable_rule = require("../application/rule/methods/disable/disable_rule");
var _mute_instance = require("../application/rule/methods/mute_alert/mute_instance");
var _unmute_all = require("../application/rule/methods/unmute_all");
var _mute_all = require("../application/rule/methods/mute_all");
var _unmute_instance = require("../application/rule/methods/unmute_alert/unmute_instance");
var _run_soon = require("./methods/run_soon");
var _rule_types = require("../application/rule/methods/rule_types/rule_types");
var _get_schedule_frequency = require("../application/rule/methods/get_schedule_frequency/get_schedule_frequency");
var _bulk_untrack_alerts = require("../application/rule/methods/bulk_untrack/bulk_untrack_alerts");
var _schedule = require("../application/backfill/methods/schedule");
var _get2 = require("../application/backfill/methods/get");
var _find2 = require("../application/backfill/methods/find");
var _delete2 = require("../application/backfill/methods/delete");
var _find_gaps = require("../application/rule/methods/find_gaps");
var _fill_gap_by_id = require("../application/rule/methods/fill_gap_by_id");
var _get_rule_ids_with_gaps = require("../application/rule/methods/get_rule_ids_with_gaps");
var _get_gaps_summary_by_rule_ids = require("../application/rule/methods/get_gaps_summary_by_rule_ids");
var _get_execution_summary = require("./methods/get_execution_summary");
var _bulk_fill_gaps_by_rule_ids = require("../application/rule/methods/bulk_fill_gaps_by_rule_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsToExcludeFromPublicApi = exports.fieldsToExcludeFromPublicApi = ['monitoring', 'mapped_params', 'snoozeSchedule', 'activeSnoozes'];
const fieldsToExcludeFromRevisionUpdates = exports.fieldsToExcludeFromRevisionUpdates = new Set(['activeSnoozes', 'alertTypeId', 'apiKey', 'apiKeyOwner', 'apiKeyCreatedByUser', 'consumer', 'createdAt', 'createdBy', 'enabled', 'executionStatus', 'id', 'isSnoozedUntil', 'lastRun', 'monitoring', 'muteAll', 'mutedInstanceIds', 'nextRun', 'revision', 'running', 'snoozeSchedule', 'systemActions', 'updatedBy', 'updatedAt']);
class RulesClient {
  constructor(context) {
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "aggregate", params => (0, _aggregate.aggregateRules)(this.context, params));
    (0, _defineProperty2.default)(this, "clone", params => (0, _clone.cloneRule)(this.context, params));
    (0, _defineProperty2.default)(this, "create", params => (0, _create.createRule)(this.context, params));
    (0, _defineProperty2.default)(this, "delete", params => (0, _delete.deleteRule)(this.context, params));
    (0, _defineProperty2.default)(this, "find", params => (0, _find.findRules)(this.context, params));
    (0, _defineProperty2.default)(this, "get", params => (0, _get.getRule)(this.context, params));
    (0, _defineProperty2.default)(this, "resolve", params => (0, _resolve.resolveRule)(this.context, params));
    (0, _defineProperty2.default)(this, "update", params => (0, _update.updateRule)(this.context, params));
    (0, _defineProperty2.default)(this, "getAlertState", params => (0, _get_alert_state.getAlertState)(this.context, params));
    (0, _defineProperty2.default)(this, "getAlertSummary", params => (0, _get_alert_summary.getAlertSummary)(this.context, params));
    (0, _defineProperty2.default)(this, "getExecutionLogForRule", params => (0, _get_execution_log.getExecutionLogForRule)(this.context, params));
    (0, _defineProperty2.default)(this, "getGlobalExecutionLogWithAuth", params => (0, _get_execution_log.getGlobalExecutionLogWithAuth)(this.context, params));
    (0, _defineProperty2.default)(this, "getRuleExecutionKPI", params => (0, _get_execution_kpi.getRuleExecutionKPI)(this.context, params));
    (0, _defineProperty2.default)(this, "getGlobalExecutionKpiWithAuth", params => (0, _get_execution_kpi.getGlobalExecutionKpiWithAuth)(this.context, params));
    (0, _defineProperty2.default)(this, "getGlobalExecutionSummaryWithAuth", params => (0, _get_execution_summary.getGlobalExecutionSummaryWithAuth)(this.context, params));
    (0, _defineProperty2.default)(this, "getActionErrorLog", params => (0, _get_action_error_log.getActionErrorLog)(this.context, params));
    (0, _defineProperty2.default)(this, "getActionErrorLogWithAuth", params => (0, _get_action_error_log.getActionErrorLogWithAuth)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkGetRules", params => (0, _bulk_get.bulkGetRules)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkDeleteRules", options => (0, _bulk_delete.bulkDeleteRules)(this.context, options));
    (0, _defineProperty2.default)(this, "bulkEdit", options => (0, _bulk_edit_rules.bulkEditRules)(this.context, options));
    (0, _defineProperty2.default)(this, "bulkEnableRules", params => (0, _bulk_enable.bulkEnableRules)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkDisableRules", options => (0, _bulk_disable.bulkDisableRules)(this.context, options));
    (0, _defineProperty2.default)(this, "updateRuleApiKey", params => (0, _update_rule_api_key.updateRuleApiKey)(this.context, params));
    (0, _defineProperty2.default)(this, "disableRule", params => (0, _disable_rule.disableRule)(this.context, params));
    (0, _defineProperty2.default)(this, "enableRule", params => (0, _enable_rule.enableRule)(this.context, params));
    (0, _defineProperty2.default)(this, "snooze", options => (0, _snooze.snoozeRule)(this.context, options));
    (0, _defineProperty2.default)(this, "unsnooze", options => (0, _unsnooze.unsnoozeRule)(this.context, options));
    (0, _defineProperty2.default)(this, "muteAll", options => (0, _mute_all.muteAll)(this.context, options));
    (0, _defineProperty2.default)(this, "unmuteAll", options => (0, _unmute_all.unmuteAll)(this.context, options));
    (0, _defineProperty2.default)(this, "muteInstance", options => (0, _mute_instance.muteInstance)(this.context, options));
    (0, _defineProperty2.default)(this, "unmuteInstance", options => (0, _unmute_instance.unmuteInstance)(this.context, options));
    (0, _defineProperty2.default)(this, "bulkUntrackAlerts", options => (0, _bulk_untrack_alerts.bulkUntrackAlerts)(this.context, options));
    (0, _defineProperty2.default)(this, "runSoon", options => (0, _run_soon.runSoon)(this.context, options));
    (0, _defineProperty2.default)(this, "listRuleTypes", () => (0, _rule_types.listRuleTypes)(this.context));
    (0, _defineProperty2.default)(this, "scheduleBackfill", params => (0, _schedule.scheduleBackfill)(this.context, params));
    (0, _defineProperty2.default)(this, "getBackfill", id => (0, _get2.getBackfill)(this.context, id));
    (0, _defineProperty2.default)(this, "findBackfill", params => (0, _find2.findBackfill)(this.context, params));
    (0, _defineProperty2.default)(this, "deleteBackfill", id => (0, _delete2.deleteBackfill)(this.context, id));
    (0, _defineProperty2.default)(this, "getTags", params => (0, _tags.getRuleTags)(this.context, params));
    (0, _defineProperty2.default)(this, "getScheduleFrequency", () => (0, _get_schedule_frequency.getScheduleFrequency)(this.context));
    (0, _defineProperty2.default)(this, "findGaps", params => (0, _find_gaps.findGaps)(this.context, params));
    (0, _defineProperty2.default)(this, "fillGapById", params => (0, _fill_gap_by_id.fillGapById)(this.context, params));
    (0, _defineProperty2.default)(this, "bulkFillGapsByRuleIds", (params, options) => (0, _bulk_fill_gaps_by_rule_ids.bulkFillGapsByRuleIds)(this.context, params, options));
    (0, _defineProperty2.default)(this, "getRuleIdsWithGaps", params => (0, _get_rule_ids_with_gaps.getRuleIdsWithGaps)(this.context, params));
    (0, _defineProperty2.default)(this, "getGapsSummaryByRuleIds", params => (0, _get_gaps_summary_by_rule_ids.getGapsSummaryByRuleIds)(this.context, params));
    this.context = {
      ...context,
      minimumScheduleIntervalInMs: (0, _parse_duration.parseDuration)(context.minimumScheduleInterval.value),
      fieldsToExcludeFromPublicApi
    };
  }
  getSpaceId() {
    return this.context.spaceId;
  }
  getAuthorization() {
    return this.context.authorization;
  }
  getAuditLogger() {
    return this.context.auditLogger;
  }
}
exports.RulesClient = RulesClient;