"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_SAVED_OBJECT_TYPE = void 0;
exports.getRuleIdsWithGaps = getRuleIdsWithGaps;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _build_gaps_filter = require("../../../../lib/rule_gaps/build_gaps_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_SAVED_OBJECT_TYPE = exports.RULE_SAVED_OBJECT_TYPE = 'alert';
async function getRuleIdsWithGaps(context, params) {
  try {
    var _aggs$aggregations, _aggs$aggregations2, _uniqueRuleIdsAgg$buc, _resultBuckets$map;
    let authorizationTuple;
    try {
      authorizationTuple = await context.authorization.getFindAuthorizationFilter({
        authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
        filterOpts: {
          type: _authorization.AlertingAuthorizationFilterType.KQL,
          fieldNames: {
            ruleTypeId: 'kibana.alert.rule.rule_type_id',
            consumer: 'kibana.alert.rule.consumer'
          }
        }
      });
    } catch (error) {
      var _context$auditLogger;
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
        action: _audit_events.RuleAuditAction.GET_RULES_WITH_GAPS,
        error
      }));
      throw error;
    }
    const {
      start,
      end,
      statuses
    } = params;
    const eventLogClient = await context.getEventLogClient();
    const filter = (0, _build_gaps_filter.buildGapsFilter)({
      start,
      end,
      statuses,
      hasUnfilledIntervals: params.hasUnfilledIntervals,
      hasInProgressIntervals: params.hasInProgressIntervals,
      hasFilledIntervals: params.hasFilledIntervals
    });
    const aggs = await eventLogClient.aggregateEventsWithAuthFilter(RULE_SAVED_OBJECT_TYPE, authorizationTuple.filter, {
      filter,
      aggs: {
        latest_gap_timestamp: {
          max: {
            field: '@timestamp'
          }
        },
        unique_rule_ids: {
          terms: {
            field: 'rule.id',
            size: 10000
          }
        }
      }
    });
    const uniqueRuleIdsAgg = (_aggs$aggregations = aggs.aggregations) === null || _aggs$aggregations === void 0 ? void 0 : _aggs$aggregations.unique_rule_ids;
    const latestGapTimestampAgg = (_aggs$aggregations2 = aggs.aggregations) === null || _aggs$aggregations2 === void 0 ? void 0 : _aggs$aggregations2.latest_gap_timestamp;
    const resultBuckets = (_uniqueRuleIdsAgg$buc = uniqueRuleIdsAgg === null || uniqueRuleIdsAgg === void 0 ? void 0 : uniqueRuleIdsAgg.buckets) !== null && _uniqueRuleIdsAgg$buc !== void 0 ? _uniqueRuleIdsAgg$buc : [];
    const ruleIds = (_resultBuckets$map = resultBuckets.map(bucket => bucket.key)) !== null && _resultBuckets$map !== void 0 ? _resultBuckets$map : [];
    const result = {
      total: ruleIds === null || ruleIds === void 0 ? void 0 : ruleIds.length,
      ruleIds,
      latestGapTimestamp: latestGapTimestampAgg === null || latestGapTimestampAgg === void 0 ? void 0 : latestGapTimestampAgg.value
    };
    return result;
  } catch (err) {
    const errorMessage = `Failed to find rules with gaps`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}