"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styles = exports.TruncatedText = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const styles = exports.styles = {
  truncatedText: (0, _react.css)`
    text-overflow: ellipsis;
    display: -webkit-box;
    -webkit-line-clamp: ${LINE_CLAMP};
    -webkit-box-orient: vertical;
    overflow: hidden;
    word-break: break-word;
  `
};
const TruncatedText = exports.TruncatedText = /*#__PURE__*/_react2.default.memo(({
  text
}) => {
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.truncatedText
  }, text);
});
TruncatedText.displayName = 'TruncatedText';