"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overallHistogramHandlerFactory = void 0;
var _constants = require("@kbn/aiops-log-rate-analysis/constants");
var _is_request_aborted_error = require("@kbn/aiops-common/is_request_aborted_error");
var _get_histogram_query = require("@kbn/aiops-log-rate-analysis/queries/get_histogram_query");
var _mini_histogram_utils = require("@kbn/aiops-log-rate-analysis/queries/mini_histogram_utils");
var _mlRandomSamplerUtils = require("@kbn/ml-random-sampler-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overallHistogramHandlerFactory = ({
  abortSignal,
  esClient,
  requestBody,
  logDebugMessage,
  logger,
  responseStream,
  stateHandler
}) => async () => {
  var _stateHandler$sampleP, _resp;
  logDebugMessage('Fetch overall histogram.');
  const overallHistogramQuery = (0, _get_histogram_query.getHistogramQuery)(requestBody);
  const miniHistogramAgg = (0, _mini_histogram_utils.getMiniHistogramAgg)(requestBody);
  const {
    wrap,
    unwrap
  } = (0, _mlRandomSamplerUtils.createRandomSamplerWrapper)({
    probability: (_stateHandler$sampleP = stateHandler.sampleProbability()) !== null && _stateHandler$sampleP !== void 0 ? _stateHandler$sampleP : 1,
    seed: _constants.RANDOM_SAMPLER_SEED
  });
  let resp;
  try {
    resp = await esClient.search({
      index: requestBody.index,
      size: 0,
      body: {
        query: overallHistogramQuery,
        aggs: wrap(miniHistogramAgg),
        size: 0
      }
    }, {
      signal: abortSignal,
      maxRetries: 0
    });
  } catch (e) {
    if (!(0, _is_request_aborted_error.isRequestAbortedError)(e)) {
      logger.error(`Failed to fetch the overall histogram data, got: \n${e.toString()}`);
      responseStream.pushError(`Failed to fetch overall histogram data.`);
    }
    // Still continue the analysis even if loading the overall histogram fails.
  }
  if (stateHandler.shouldStop()) {
    logDebugMessage('shouldStop after fetching overall histogram.');
    responseStream.end();
    return [];
  }
  if (((_resp = resp) === null || _resp === void 0 ? void 0 : _resp.aggregations) === undefined) {
    if (!(0, _is_request_aborted_error.isRequestAbortedError)(resp)) {
      if (logger) {
        logger.error(`Failed to fetch the histogram data chunk, got: \n${JSON.stringify(resp, null, 2)}`);
      }
      responseStream.pushError(`Failed to fetch the histogram data chunk.`);
    }
    return [];
  }
  const unwrappedResp = unwrap(resp.aggregations);
  return unwrappedResp.mini_histogram.buckets;
};
exports.overallHistogramHandlerFactory = overallHistogramHandlerFactory;