"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveEmbeddableLogRateAnalysisUserInput = resolveEmbeddableLogRateAnalysisUserInput;
var _presentationContainers = require("@kbn/presentation-containers");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _log_rate_analysis_embeddable_initializer = require("./log_rate_analysis_embeddable_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolveEmbeddableLogRateAnalysisUserInput(coreStart, pluginStart, parentApi, focusedPanelId, isNewPanel, logRateAnalysisControlsApi, deletePanel, initialState) {
  const {
    overlays
  } = coreStart;
  const overlayTracker = (0, _presentationContainers.tracksOverlays)(parentApi) ? parentApi : undefined;
  let hasChanged = false;
  return new Promise(async (resolve, reject) => {
    try {
      const cancelChanges = () => {
        if (isNewPanel && deletePanel) {
          deletePanel();
        } else if (hasChanged && logRateAnalysisControlsApi && initialState) {
          // Reset to initialState in case user has changed the preview state
          logRateAnalysisControlsApi.updateUserInput(initialState);
        }
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const update = async nextUpdate => {
        resolve(nextUpdate);
        flyoutSession.close();
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
      };
      const preview = async nextUpdate => {
        if (logRateAnalysisControlsApi) {
          logRateAnalysisControlsApi.updateUserInput(nextUpdate);
          hasChanged = true;
        }
      };
      const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_log_rate_analysis_embeddable_initializer.LogRateAnalysisEmbeddableInitializer, {
        dataViews: pluginStart.data.dataViews,
        IndexPatternSelect: pluginStart.unifiedSearch.ui.IndexPatternSelect,
        initialInput: initialState,
        onCreate: update,
        onCancel: cancelChanges,
        onPreview: preview,
        isNewPanel: isNewPanel
      }), coreStart), {
        ownFocus: true,
        size: 's',
        type: 'push',
        paddingSize: 'm',
        hideCloseButton: true,
        'data-test-subj': 'aiopsLogRateAnalysisEmbeddableInitializer',
        'aria-labelledby': 'logRateAnalysisConfig',
        onClose: () => {
          reject();
          flyoutSession.close();
          overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        }
      });
      if ((0, _presentationContainers.tracksOverlays)(parentApi)) {
        parentApi.openOverlay(flyoutSession, {
          focusedPanelId
        });
      }
    } catch (error) {
      reject(error);
    }
  });
}