"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogCategorizationDiscoverWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _storage = require("../../../types/storage");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _log_categorization_for_discover = require("./log_categorization_for_discover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const localStorage = new _public2.Storage(window.localStorage);
const LogCategorizationDiscoverWrapper = ({
  appContextValue,
  props
}) => {
  const I18nContext = appContextValue.i18n.Context;
  const datePickerDeps = {
    ...(0, _lodash.pick)(appContextValue, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _public.UI_SETTINGS
  };
  return /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appContextValue
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, datePickerDeps, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: null
  }, /*#__PURE__*/_react.default.createElement(_log_categorization_for_discover.LogCategorizationDiscover, {
    input: props.input,
    renderViewModeToggle: props.renderViewModeToggle
  }))))));
};

// eslint-disable-next-line import/no-default-export
exports.LogCategorizationDiscoverWrapper = LogCategorizationDiscoverWrapper;
var _default = exports.default = LogCategorizationDiscoverWrapper;