"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.border = void 0;
var _functions = require("../../../../global_styling/functions");
var _utils = require("../../../../services/theme/utils");
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var border = exports.border = {
  color: (0, _utils.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      borderBaseSubdued = _ref2[0];
    return borderBaseSubdued;
  }, ['colors.borderBaseSubdued']),
  width: {
    thin: '1px',
    thick: '2px'
  },
  radius: {
    medium: (0, _utils.computed)((0, _functions.sizeToPixel)(0.375)),
    small: (0, _utils.computed)((0, _functions.sizeToPixel)(0.25))
  },
  thin: (0, _utils.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
      width = _ref4[0],
      color = _ref4[1];
    return "".concat(width.thin, " solid ").concat(color);
  }, ['border.width', 'border.color']),
  thick: (0, _utils.computed)(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 2),
      width = _ref6[0],
      color = _ref6[1];
    return "".concat(width.thick, " solid ").concat(color);
  }, ['border.width', 'border.color']),
  editable: (0, _utils.computed)(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 2),
      width = _ref8[0],
      color = _ref8[1];
    return "".concat(width.thick, " dotted ").concat(color);
  }, ['border.width', 'border.color'])
};