"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStepIndicator = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _excluded = ["className", "number", "status"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;"
} : {
  name: "1v4nm53-EuiTourStepIndicator",
  styles: "display:inline-block;label:EuiTourStepIndicator;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var EuiTourStepIndicator = exports.EuiTourStepIndicator = function EuiTourStepIndicator(_ref2) {
  var className = _ref2.className,
    number = _ref2.number,
    status = _ref2.status,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var classes = (0, _classnames.default)('euiTourStepIndicator', className);
  var indicatorIcon;
  if (status === 'active') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isActive",
      default: "active"
    }, function (isActive) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isActive,
        color: "success",
        "aria-current": "step"
      });
    });
  } else if (status === 'complete') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isComplete",
      default: "complete"
    }, function (isComplete) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isComplete,
        color: "subdued"
      });
    });
  } else if (status === 'incomplete') {
    indicatorIcon = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isIncomplete",
      default: "incomplete"
    }, function (isIncomplete) {
      return (0, _react2.jsx)(_icon.EuiIcon, {
        type: "dot",
        "aria-label": isIncomplete,
        color: "subdued"
      });
    });
  }
  return (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTourStepIndicator.ariaLabel",
    default: "Step {number} {status}",
    values: {
      status: status,
      number: number
    }
  }, function (ariaLabel) {
    return (0, _react2.jsx)("li", _extends({
      css: _ref,
      className: classes,
      "aria-label": ariaLabel
    }, rest), indicatorIcon);
  });
};
EuiTourStepIndicator.propTypes = {
  number: _propTypes.default.number.isRequired,
  status: _propTypes.default.oneOf(["complete", "incomplete", "active"]).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};