"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCodeBlockLineStyles = void 0;
var _css = require("@emotion/css");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Note: These styles must be in a separate file due to using `css` from `@emotion/css`
// (i.e., applying styles in vanilla JS / directly to DOM nodes instead of React)

var euiCodeBlockLineStyles = exports.euiCodeBlockLineStyles = function euiCodeBlockLineStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var lineMargins = euiTheme.size.m;
  var lineWidth = euiTheme.border.width.thin;

  // Increase highlight border width in high contrast modes
  var highlightWidth = highContrastMode ? (0, _global_styling.mathWithUnits)(euiTheme.border.width.thick, function (x) {
    return x * 1.5;
  }) : euiTheme.border.width.thick;
  var highlightOffset = (0, _global_styling.mathWithUnits)([lineMargins, lineWidth, highlightWidth], function (x, y, z) {
    return x + y - z;
  });
  return {
    euiCodeBlock__line: /*#__PURE__*/(0, _css.css)(process.env.NODE_ENV === "production" ? {
      name: "yn676d-euiCodeBlock__line",
      styles: "display:block;label:euiCodeBlock__line;"
    } : {
      name: "yn676d-euiCodeBlock__line",
      styles: "display:block;label:euiCodeBlock__line;",
      toString: _EMOTION_STRINGIFIED_CSS_ERROR__
    }),
    hasLineNumbers: /*#__PURE__*/(0, _css.css)(process.env.NODE_ENV === "production" ? {
      name: "156gjef-hasLineNumbers",
      styles: "display:flex;user-select:none;label:hasLineNumbers;"
    } : {
      name: "156gjef-hasLineNumbers",
      styles: "display:flex;user-select:none;label:hasLineNumbers;",
      toString: _EMOTION_STRINGIFIED_CSS_ERROR__
    }),
    lineText: {
      euiCodeBlock__lineText: /*#__PURE__*/(0, _css.css)("flex-grow:1;display:inline-block;padding-inline-start:", lineMargins, ";border-inline-start:", lineWidth, " solid ", euiTheme.border.color, ";user-select:text;;label:euiCodeBlock__lineText;"),
      isHighlighted: /*#__PURE__*/(0, _css.css)("background:", euiTheme.colors.backgroundBasePrimary, ";border-inline-start:", highlightWidth, " solid ", euiTheme.colors.primary, ";padding-inline-start:", highlightOffset, ";;label:isHighlighted;")
    },
    lineNumber: {
      euiCodeBlock__lineNumberWrapper: /*#__PURE__*/(0, _css.css)("position:relative;flex-grow:0;flex-shrink:0;user-select:none;padding-inline-end:", lineMargins, ";box-sizing:content-box;;label:euiCodeBlock__lineNumberWrapper;"),
      euiCodeBlock__lineNumber: /*#__PURE__*/(0, _css.css)("color:", euiTheme.colors.textSubdued, ";text-align:end;display:block;&::before{content:attr(data-line-number);};label:euiCodeBlock__lineNumber;")
    }
  };
};