"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upgradeAgentPolicySchemaVersion = upgradeAgentPolicySchemaVersion;
var _constants = require("../../constants");
var _agent_policy = require("../agent_policy");
var _app_context = require("../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_BATCH_SIZE = 2;
function getOutdatedAgentPoliciesBatch(soClient, batchSize) {
  return _agent_policy.agentPolicyService.list(soClient, {
    perPage: batchSize,
    kuery: `NOT ${_constants.AGENT_POLICY_SAVED_OBJECT_TYPE}.schema_version:${_constants.FLEET_AGENT_POLICIES_SCHEMA_VERSION}`,
    fields: ['id'] // we only need the ID of the agent policy
  });
}

// used to migrate ingest-agent-policies SOs to .fleet-policies
// fetch SOs from ingest-agent-policies with outdated schema_version
// deploy outdated policies to .fleet-policies index
// bump oudated SOs schema_version
async function upgradeAgentPolicySchemaVersion(soClient) {
  var _config$setup$agentPo, _config$setup;
  const config = _app_context.appContextService.getConfig();
  const logger = _app_context.appContextService.getLogger();
  const batchSize = (_config$setup$agentPo = config === null || config === void 0 ? void 0 : (_config$setup = config.setup) === null || _config$setup === void 0 ? void 0 : _config$setup.agentPolicySchemaUpgradeBatchSize) !== null && _config$setup$agentPo !== void 0 ? _config$setup$agentPo : DEFAULT_BATCH_SIZE;
  let outdatedAgentPolicies = await getOutdatedAgentPoliciesBatch(soClient, batchSize);
  logger.debug(`Found ${outdatedAgentPolicies.total} outdated agent policies`);
  while (outdatedAgentPolicies.total > 0) {
    const start = Date.now();
    const outdatedAgentPolicyIds = outdatedAgentPolicies.items.map(outdatedAgentPolicy => outdatedAgentPolicy.id);
    await _agent_policy.agentPolicyService.deployPolicies(soClient, outdatedAgentPolicyIds);
    outdatedAgentPolicies = await getOutdatedAgentPoliciesBatch(soClient, batchSize);
    logger.debug(`Upgraded ${outdatedAgentPolicyIds.length} agent policies in ${Date.now() - start}ms, ${outdatedAgentPolicies.total} remaining`);
  }
}