"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureSpaceSettings = ensureSpaceSettings;
var _common = require("@kbn/spaces-plugin/common");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _ = require("..");
var _constants = require("../../constants");
var _space_settings = require("../spaces/space_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureSpaceSettings(configSpaceSettingsArray) {
  const soClient = _.appContextService.getInternalUserSOClientWithoutSpaceExtension();

  // Get all existing config space
  const existingConfigSpaceSettingsSOs = await soClient.find({
    type: _constants.SPACE_SETTINGS_SAVED_OBJECT_TYPE,
    perPage: _constants.SO_SEARCH_LIMIT,
    namespaces: ['*']
  });
  const existingConfigSpaceSettingsSOMap = existingConfigSpaceSettingsSOs.saved_objects.reduce((acc, so) => {
    var _so$namespaces$, _so$namespaces;
    acc.set((_so$namespaces$ = (_so$namespaces = so.namespaces) === null || _so$namespaces === void 0 ? void 0 : _so$namespaces[0]) !== null && _so$namespaces$ !== void 0 ? _so$namespaces$ : _common.DEFAULT_SPACE_ID, so);
    return acc;
  }, new Map());
  for (const configSpaceSettings of configSpaceSettingsArray) {
    // Check for existing
    const existingConfigSpaceSettingsSO = existingConfigSpaceSettingsSOMap.get(configSpaceSettings.space_id);
    if (!existingConfigSpaceSettingsSO) {
      await (0, _space_settings.saveSpaceSettings)({
        spaceId: configSpaceSettings.space_id,
        settings: {
          allowed_namespace_prefixes: configSpaceSettings.allowed_namespace_prefixes,
          managed_by: 'kibana_config'
        },
        managedBy: 'kibana_config'
      });
    } else if (!(0, _fastDeepEqual.default)(existingConfigSpaceSettingsSO.attributes.allowed_namespace_prefixes, configSpaceSettings.allowed_namespace_prefixes) || !existingConfigSpaceSettingsSO.attributes.managed_by) {
      await (0, _space_settings.saveSpaceSettings)({
        spaceId: configSpaceSettings.space_id,
        settings: {
          allowed_namespace_prefixes: configSpaceSettings.allowed_namespace_prefixes,
          managed_by: 'kibana_config'
        },
        managedBy: 'kibana_config'
      });
    }
  }
  for (const spaceId of existingConfigSpaceSettingsSOMap.keys()) {
    if (!configSpaceSettingsArray.some(config => {
      var _existingConfigSpaceS, _existingConfigSpaceS2;
      return config.space_id === spaceId && ((_existingConfigSpaceS = existingConfigSpaceSettingsSOMap.get(spaceId)) === null || _existingConfigSpaceS === void 0 ? void 0 : (_existingConfigSpaceS2 = _existingConfigSpaceS.attributes) === null || _existingConfigSpaceS2 === void 0 ? void 0 : _existingConfigSpaceS2.managed_by) === 'kibana_config';
    })) {
      await (0, _space_settings.saveSpaceSettings)({
        spaceId,
        settings: {
          managed_by: null
        },
        managedBy: 'kibana_config'
      });
    }
  }
}