"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssetsDataFromAssetsMap = getAssetsDataFromAssetsMap;
exports.getAssetsFromAssetsMap = getAssetsFromAssetsMap;
var _archive = require("../archive");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maybeFilterByDataset = (packageInfo, datasetName) => path => {
  const basePath = `${packageInfo.name}-${packageInfo.version}`;
  const comparePaths = (packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.type) === 'input' ? [`${basePath}/agent/input/`, `${basePath}/fields/`] : [`${basePath}/data_stream/${datasetName}/`];
  return comparePaths.some(comparePath => path.includes(comparePath));
};
function getAssetsFromAssetsMap(packageInfo, assetsMap, filter = path => true, datasetName) {
  const paths = [...assetsMap.keys()];
  if (!paths || paths.length === 0) return [];

  // filter out directories
  let assets = paths.filter(path => !path.endsWith('/'));
  if (datasetName) {
    assets = paths.filter(maybeFilterByDataset(packageInfo, datasetName));
  }
  return assets.filter(filter);
}
function getAssetsDataFromAssetsMap(packageInfo, assetsMap, filter = path => true, datasetName) {
  const assets = getAssetsFromAssetsMap(packageInfo, assetsMap, filter, datasetName);
  const entries = assets.map(path => {
    const buffer = (0, _archive.getAssetFromAssetsMap)(assetsMap, path);
    return {
      path,
      buffer
    };
  });
  return entries;
}