"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSpaceAwareSaveobjectsClients = getSpaceAwareSaveobjectsClients;
var _app_context = require("../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSpaceAwareSaveobjectsClients(spaceId) {
  // Saved object client need to be scopped with the package space for saved object tagging
  const savedObjectClientWithSpace = _app_context.appContextService.getInternalUserSOClientForSpaceId(spaceId);
  const savedObjectsImporter = _app_context.appContextService.getSavedObjects().createImporter(savedObjectClientWithSpace, {
    importSizeLimit: 15_000
  });
  const savedObjectTagAssignmentService = _app_context.appContextService.getSavedObjectsTagging().createInternalAssignmentService({
    client: savedObjectClientWithSpace
  });
  const savedObjectTagClient = _app_context.appContextService.getSavedObjectsTagging().createTagClient({
    client: savedObjectClientWithSpace
  });
  return {
    savedObjectClientWithSpace,
    savedObjectsImporter,
    savedObjectTagAssignmentService,
    savedObjectTagClient
  };
}