"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migratePackagePolicyToV8110 = exports.migratePackagePolicyEvictionsFromV8110 = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migratePackagePolicyToV8110 = packagePolicyDoc => {
  var _packagePolicyDoc$att;
  if (((_packagePolicyDoc$att = packagePolicyDoc.attributes.package) === null || _packagePolicyDoc$att === void 0 ? void 0 : _packagePolicyDoc$att.name) !== 'endpoint') {
    return {
      attributes: packagePolicyDoc.attributes
    };
  }
  const updatedPackagePolicyDoc = packagePolicyDoc;
  const input = updatedPackagePolicyDoc.attributes.inputs[0];
  if (input && input.config) {
    const policy = input.config.policy.value;
    policy.global_manifest_version = 'latest';
  }
  return {
    attributes: {
      inputs: updatedPackagePolicyDoc.attributes.inputs
    }
  };
};
exports.migratePackagePolicyToV8110 = migratePackagePolicyToV8110;
const migratePackagePolicyEvictionsFromV8110 = unknownAttributes => {
  var _attributes$package;
  const attributes = unknownAttributes;
  if (((_attributes$package = attributes.package) === null || _attributes$package === void 0 ? void 0 : _attributes$package.name) !== 'endpoint') {
    return attributes;
  }
  const updatedAttributes = attributes;
  const input = updatedAttributes.inputs[0];
  if (input && input.config) {
    input.config.policy.value = (0, _lodash.omit)(input.config.policy.value, ['global_manifest_version']);
  }
  return updatedAttributes;
};
exports.migratePackagePolicyEvictionsFromV8110 = migratePackagePolicyEvictionsFromV8110;