"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _experimental_features = require("../../../common/experimental_features");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _enrollment_settings_handler = require("./enrollment_settings_handler");
var _settings_handler = require("./settings_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = (router, config) => {
  const experimentalFeatures = (0, _experimental_features.parseExperimentalConfigValue)(config.enableExperimental);
  if (experimentalFeatures.useSpaceAwareness) {
    router.versioned.get({
      path: _constants2.SETTINGS_API_ROUTES.SPACE_INFO_PATTERN,
      fleetAuthz: authz => {
        return authz.fleet.readSettings || authz.integrations.writeIntegrationPolicies || authz.fleet.allAgentPolicies;
      },
      summary: `Get space settings`
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _types.GetSpaceSettingsRequestSchema
      }
    }, _settings_handler.getSpaceSettingsHandler);
    router.versioned.put({
      path: _constants2.SETTINGS_API_ROUTES.SPACE_UPDATE_PATTERN,
      fleetAuthz: {
        fleet: {
          allSettings: true
        }
      },
      summary: `Create space settings`
    }).addVersion({
      version: _constants.API_VERSIONS.public.v1,
      validate: {
        request: _types.PutSpaceSettingsRequestSchema
      }
    }, _settings_handler.putSpaceSettingsHandler);
  }
  router.versioned.get({
    path: _constants2.SETTINGS_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      fleet: {
        readSettings: true
      }
    },
    summary: `Get settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetSettingsRequestSchema
    }
  }, _settings_handler.getSettingsHandler);
  router.versioned.put({
    path: _constants2.SETTINGS_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: {
      fleet: {
        allSettings: true
      }
    },
    summary: `Update settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.PutSettingsRequestSchema
    }
  }, _settings_handler.putSettingsHandler);
  router.versioned.get({
    path: _constants2.SETTINGS_API_ROUTES.ENROLLMENT_INFO_PATTERN,
    fleetAuthz: authz => {
      return authz.fleet.addAgents || authz.fleet.addFleetServers;
    },
    summary: `Get enrollment settings`,
    options: {
      tags: ['oas-tag:Fleet internals']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetEnrollmentSettingsRequestSchema
    }
  }, _enrollment_settings_handler.getEnrollmentSettingsHandler);
};
exports.registerRoutes = registerRoutes;