"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumTransformAssets = exports.TransformInstallWithCurrentUserPermissionCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _hooks = require("../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNumTransformAssets = assets => {
  var _assets$elasticsearch, _assets$elasticsearch2, _assets$elasticsearch3, _assets$elasticsearch4;
  if (!assets || !(Array.isArray((_assets$elasticsearch = assets.elasticsearch) === null || _assets$elasticsearch === void 0 ? void 0 : _assets$elasticsearch.transform) && ((_assets$elasticsearch2 = assets.elasticsearch) === null || _assets$elasticsearch2 === void 0 ? void 0 : (_assets$elasticsearch3 = _assets$elasticsearch2.transform) === null || _assets$elasticsearch3 === void 0 ? void 0 : _assets$elasticsearch3.length) > 0)) {
    return 0;
  }
  return (0, _lodash.uniqBy)((_assets$elasticsearch4 = assets.elasticsearch) === null || _assets$elasticsearch4 === void 0 ? void 0 : _assets$elasticsearch4.transform, 'file').length;
};
exports.getNumTransformAssets = getNumTransformAssets;
const TransformInstallWithCurrentUserPermissionCallout = ({
  count
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.transformInstallWithCurrentUserPermissionCallout.text",
    defaultMessage: "This package has {count, plural, one {one} other {#}} {docsLink} which will be created and started with the same roles as the user installing the package.",
    values: {
      count,
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.transforms.overview,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.createPackagePolicy.transformInstallWithCurrentUserPermissionCallout.docsLink",
        defaultMessage: "{count, plural, one {transform asset} other {transform assets}}",
        values: {
          count
        }
      }))
    }
  }));
};
exports.TransformInstallWithCurrentUserPermissionCallout = TransformInstallWithCurrentUserPermissionCallout;