"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Screenshots = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Pagination = (0, _styledComponents.default)(_eui.EuiPagination)`
  max-width: 130px;
`;
const Screenshots = exports.Screenshots = /*#__PURE__*/(0, _react.memo)(({
  images,
  packageName,
  version
}) => {
  const {
    toPackageImage
  } = (0, _hooks.useLinks)();
  const [currentImageIndex, setCurrentImageIndex] = (0, _react.useState)(0);
  const maxImageIndex = (0, _react.useMemo)(() => images.length - 1, [images.length]);
  const currentImageUrl = (0, _react.useMemo)(() => toPackageImage(images[currentImageIndex], packageName, version), [currentImageIndex, images, packageName, toPackageImage, version]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.screenshotsTitle",
    defaultMessage: "Screenshots"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(Pagination, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.epm.screenshotPaginationAriaLabel', {
      defaultMessage: '{packageName} screenshot pagination',
      values: {
        packageName
      }
    }),
    pageCount: maxImageIndex + 1,
    activePage: currentImageIndex,
    onPageClick: activePage => setCurrentImageIndex(activePage),
    compressed: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, currentImageUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    allowFullScreen: true,
    hasShadow: true,
    alt: images[currentImageIndex].title || _i18n.i18n.translate('xpack.fleet.epm.screenshotAltText', {
      defaultMessage: '{packageName} screenshot #{imageNumber}',
      values: {
        packageName,
        imageNumber: currentImageIndex + 1
      }
    }),
    title: images[currentImageIndex].title,
    url: currentImageUrl
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.screenshotErrorText",
    defaultMessage: "Unable to load this screenshot"
  })));
});