"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFleetServerUnhealthy = useFleetServerUnhealthy;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFleetServerUnhealthy() {
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [isUnhealthy, setIsUnhealthy] = (0, _react.useState)(false);
  const fetchData = (0, _react.useCallback)(async () => {
    try {
      var _enrollmentSettingsRe;
      const enrollmentSettingsResponse = await (0, _hooks.sendGetEnrollmentSettings)();
      if (enrollmentSettingsResponse.error) {
        throw enrollmentSettingsResponse.error;
      }
      if (!((_enrollmentSettingsRe = enrollmentSettingsResponse.data) !== null && _enrollmentSettingsRe !== void 0 && _enrollmentSettingsRe.fleet_server.has_active)) {
        setIsUnhealthy(true);
      }
      setIsLoading(false);
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.fleetServerUnhealthy.requestError', {
          defaultMessage: 'An error happened while fetching fleet server status'
        })
      });
      setIsLoading(false);
    }
  }, [notifications.toasts]);
  (0, _react.useEffect)(() => {
    if (authz.fleet.addAgents || authz.fleet.addFleetServers) {
      fetchData();
    } else {
      setIsLoading(false);
      return;
    }
  }, [fetchData, authz.fleet.addAgents, authz.fleet.addFleetServers]);
  return {
    isLoading,
    isUnhealthy
  };
}