"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsIntegrationInputs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../../hooks");
var _agent_details_integration_input_status = require("./agent_details_integration_input_status");
var _input_type_utils = require("./input_type_utils");
var _input_status_utils = require("./input_status_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiLink = (0, _styledComponents.default)(_eui.EuiLink)`
  font-size: ${props => props.theme.eui.euiFontSizeS};
`;
const StyledEuiTreeView = (0, _styledComponents.default)(_eui.EuiTreeView)`
  .input-action-item-expanded {
    height: auto;
    padding-top: ${({
  theme
}) => theme.eui.euiSizeS};
    padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
    .euiTreeView__nodeLabel {
      width: 100%;
    }
  }
  .inputStatusHealth {
    padding-top: 5px;
  }
  .euiTreeView__node--expanded {
    max-height: none !important;
    .policy-response-action-expanded + div {
      .euiTreeView__node {
        // When response action item displays a callout, this needs to be overwritten to remove the default max height of EuiTreeView
        max-height: none !important;
      }
    }
  }
  .euiTreeView__node {
    max-height: none !important;
    .euiNotificationBadge {
      margin-right: 5px;
    }
    .euiTreeView__nodeLabel {
      .euiText {
        font-size: ${({
  theme
}) => theme.eui.euiFontSize};
      }
    }
  }
`;
const AgentDetailsIntegrationInputs = exports.AgentDetailsIntegrationInputs = /*#__PURE__*/(0, _react.memo)(({
  agent,
  packagePolicy,
  linkToLogs = true,
  'data-test-subj': dataTestSubj
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const inputStatusMap = (0, _react.useMemo)(() => packagePolicy.inputs.reduce((acc, current) => {
    if (!agent.components) {
      return new Map();
    }
    if (current.enabled) {
      var _getInputUnitsByPacka;
      const agentUnit = (_getInputUnitsByPacka = (0, _input_status_utils.getInputUnitsByPackage)(agent.components, packagePolicy)) === null || _getInputUnitsByPacka === void 0 ? void 0 : _getInputUnitsByPacka.find(i => i.id.match(new RegExp(current.type)));
      acc.set(current.type, agentUnit ? new _input_status_utils.InputStatusFormatter(agentUnit.status, agentUnit.message) : new _input_status_utils.InputStatusFormatter());
    }
    return acc;
  }, new Map()), [agent.components, packagePolicy]);
  const getInputStatusIcon = inputType => {
    const inputStatus = inputStatusMap.get(inputType);
    if ((inputStatus === null || inputStatus === void 0 ? void 0 : inputStatus.status) === undefined) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: "default",
        "data-test-subj": "agentDetailsIntegrationsInputStatusHealthDefault",
        className: "inputStatusHealth"
      });
    }
    return inputStatus.status === 'HEALTHY' ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "success",
      "data-test-subj": "agentDetailsIntegrationsInputStatusHealthSuccess",
      className: "inputStatusHealth"
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": "agentDetailsIntegrationsInputStatusAttentionHealth"
    }, 1);
  };
  const generateInputResponse = () => {
    return packagePolicy.inputs.reduce((acc, current) => {
      if (current.enabled) {
        const inputStatusFormatter = inputStatusMap.get(current.type);
        return [...acc, {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.viewLogsButton', {
              defaultMessage: 'View logs'
            })
          }, linkToLogs ? /*#__PURE__*/_react.default.createElement(StyledEuiLink, {
            href: getHref('agent_details', {
              agentId: agent.id,
              tabId: 'logs',
              logQuery: (0, _input_type_utils.getLogsQueryByInputType)(current.type)
            }),
            "aria-label": _i18n.i18n.translate('xpack.fleet.agentDetailsIntegrations.viewLogsButton', {
              defaultMessage: 'View logs'
            })
          }, (0, _input_type_utils.displayInputType)(current.type)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _input_type_utils.displayInputType)(current.type))),
          id: current.type,
          icon: getInputStatusIcon(current.type),
          children: !!inputStatusFormatter ? [{
            label: /*#__PURE__*/_react.default.createElement(_agent_details_integration_input_status.AgentDetailsIntegrationInputStatus, {
              inputStatusFormatter: inputStatusFormatter
            }),
            id: `input-status-${current.type}`,
            isExpanded: true,
            className: 'input-action-item-expanded'
          }] : []
        }];
      }
      return acc;
    }, []);
  };
  const generateInputsTreeView = () => {
    const inputsTotalErrors = Array.from(inputStatusMap.values()).reduce((acc, input) => {
      if (input.hasError) {
        acc += 1;
      }
      return acc;
    }, 0);
    return [{
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: inputsTotalErrors ? 'danger' : 'default',
        size: "s",
        "data-test-subj": "agentIntegrationsInputsTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentDetailsIntegrations.inputsTypeLabel",
        defaultMessage: "Inputs"
      })),
      id: 'agentIntegrationsInputs',
      icon: inputsTotalErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": "agentIntegrationsInputsStatusHealth"
      }, inputsTotalErrors) : undefined,
      children: generateInputResponse()
    }];
  };
  return /*#__PURE__*/_react.default.createElement(StyledEuiTreeView, {
    items: generateInputsTreeView(),
    showExpansionArrows: true,
    "aria-label": "inputsTreeView",
    "aria-labelledby": "inputsTreeView"
  });
});