"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendGeneratePackagePolicy = void 0;
var _constants = require("../../../../../../../constants");
var _services = require("../../../../../../../../common/services");
var _constants2 = require("../../../../../../../../common/constants");
var _services2 = require("../../../../../services");
var _hooks = require("../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendGeneratePackagePolicy = async (agentPolicyId, packageInfo, integrationToEnable) => {
  const {
    data: packagePolicyData,
    error
  } = await (0, _hooks.sendGetPackagePolicies)({
    perPage: _constants2.SO_SEARCH_LIMIT,
    page: 1,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${packageInfo.name}`
  });
  const incrementedName = (0, _services.getMaxPackageName)(packageInfo.name, packagePolicyData === null || packagePolicyData === void 0 ? void 0 : packagePolicyData.items);
  const defaultPolicy = {
    name: incrementedName,
    description: '',
    namespace: '',
    policy_id: agentPolicyId,
    policy_ids: [agentPolicyId],
    enabled: true,
    inputs: []
  };
  const packagePolicy = (0, _services2.packageToPackagePolicy)(packageInfo, agentPolicyId, defaultPolicy.namespace, defaultPolicy.name, defaultPolicy.description, integrationToEnable);
  return {
    packagePolicy,
    error
  };
};
exports.sendGeneratePackagePolicy = sendGeneratePackagePolicy;