"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PermissionsError = exports.ErrorLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _agent_requirements_page = require("../sections/agents/agent_requirements_page");
var _layouts = require("../../../layouts");
var _components = require("../components");
var _default = require("./default");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Panel = (0, _styledComponents.default)(_eui.EuiPanel)`
  max-width: 500px;
  margin-right: auto;
  margin-left: auto;
`;
const ErrorLayout = ({
  isAddIntegrationsPath,
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, isAddIntegrationsPath ? /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
  leftColumn: /*#__PURE__*/_react.default.createElement(_default.DefaultPageTitle, null)
}, children) : /*#__PURE__*/_react.default.createElement(_default.DefaultLayout, null, /*#__PURE__*/_react.default.createElement(_layouts.WithoutHeaderLayout, null, children)));
exports.ErrorLayout = ErrorLayout;
const PermissionsError = exports.PermissionsError = /*#__PURE__*/_react.default.memo(({
  error,
  requiredFleetRole
}) => {
  if (error === 'MISSING_SECURITY') {
    return /*#__PURE__*/_react.default.createElement(_agent_requirements_page.MissingESRequirementsPage, {
      missingRequirements: ['security_required', 'api_keys']
    });
  }
  if (error === 'MISSING_PRIVILEGES') {
    return /*#__PURE__*/_react.default.createElement(Panel, {
      "data-test-subj": "missingPrivilegesPrompt"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "securityApp",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        "data-test-subj": "missingPrivilegesPromptTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.permissionDeniedErrorTitle",
        defaultMessage: "Permission denied"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "missingPrivilegesPromptMessage"
      }, requiredFleetRole ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.pagePermissionDeniedErrorMessage",
        defaultMessage: "You are not authorized to access that page. It requires the {roleName} Kibana privilege for Fleet.",
        values: {
          roleName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, requiredFleetRole)
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.permissionDeniedErrorMessage",
        defaultMessage: "You are not authorized to access Fleet. Kibana privileges are required to access Fleet; the {roleName2} or {roleName1} privilege is required to access Integrations.",
        values: {
          roleName1: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "\"All\""),
          roleName2: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "\"Read\"")
        }
      }))
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.permissionsRequestErrorMessageTitle",
      defaultMessage: "Unable to check permissions"
    }),
    error: _i18n.i18n.translate('xpack.fleet.permissionsRequestErrorMessageDescription', {
      defaultMessage: 'There was a problem checking Fleet permissions'
    })
  });
});