"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileShareTokenInvalidError = exports.FileShareNotFoundError = exports.ExpiryDateInThePastError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* eslint-disable max-classes-per-file */

class FileShareError extends Error {
  constructor(message) {
    super(message);
    Error.captureStackTrace(this);
  }
}
class ExpiryDateInThePastError extends FileShareError {}
exports.ExpiryDateInThePastError = ExpiryDateInThePastError;
class FileShareNotFoundError extends FileShareError {}
exports.FileShareNotFoundError = FileShareNotFoundError;
class FileShareTokenInvalidError extends FileShareError {}
exports.FileShareTokenInvalidError = FileShareTokenInvalidError;