"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGaugeSizeByType = void 0;
var _react = require("react");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const useGaugeSizeByType = (type, setChartSize) => {
  (0, _react.useEffect)(() => {
    const maxDimensions = {
      [_common.GaugeShapes.SEMI_CIRCLE]: {
        maxDimensions: {
          x: {
            value: 600,
            unit: 'pixels'
          },
          y: {
            value: 600,
            unit: 'pixels'
          }
        },
        aspectRatio: {
          x: 2,
          y: 1.25
        }
      },
      [_common.GaugeShapes.ARC]: {
        maxDimensions: {
          x: {
            value: 600,
            unit: 'pixels'
          },
          y: {
            value: 600,
            unit: 'pixels'
          }
        },
        aspectRatio: {
          x: 1.1,
          y: 1
        }
      },
      [_common.GaugeShapes.CIRCLE]: {
        maxDimensions: {
          x: {
            value: 600,
            unit: 'pixels'
          },
          y: {
            value: 600,
            unit: 'pixels'
          }
        },
        aspectRatio: {
          x: 1,
          y: 1
        }
      },
      [_common.GaugeShapes.HORIZONTAL_BULLET]: {
        maxDimensions: {
          x: {
            value: 600,
            unit: 'pixels'
          },
          y: {
            value: 200,
            unit: 'pixels'
          }
        }
      },
      [_common.GaugeShapes.VERTICAL_BULLET]: {
        maxDimensions: {
          x: {
            value: 400,
            unit: 'pixels'
          },
          y: {
            value: 600,
            unit: 'pixels'
          }
        }
      }
    };
    setChartSize(maxDimensions[type]);
  }, [type, setChartSize]);
};
exports.useGaugeSizeByType = useGaugeSizeByType;