"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesInfo = SeriesInfo;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _series_color_picker = require("../../components/series_color_picker");
var _chart_type_select = require("./chart_type_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeriesInfo({
  seriesId,
  series,
  seriesConfig
}) {
  if (!seriesConfig) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_type_select.SeriesChartTypes, {
    seriesId: seriesId,
    series: series,
    seriesConfig: seriesConfig
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_series_color_picker.SeriesColorPicker, {
    seriesId: seriesId,
    series: series
  })));
  return null;
}