"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
var _ui_settings = require("./ui_settings");
var _routes = require("./routes");
var _extensions_registry = require("./extensions_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class EsqlServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "initContext", void 0);
    (0, _defineProperty2.default)(this, "extensionsRegistry", new _extensions_registry.ESQLExtensionsRegistry());
    this.initContext = {
      ...initContext
    };
  }
  setup(core, plugins) {
    const {
      initContext
    } = this;
    core.uiSettings.register((0, _ui_settings.getUiSettings)());
    plugins.contentManagement.favorites.registerFavoriteType('esql_query', {
      typeMetadataSchema: _configSchema.schema.object({
        queryString: _configSchema.schema.string(),
        createdAt: _configSchema.schema.string(),
        status: _configSchema.schema.string()
      })
    });
    (0, _routes.registerRoutes)(core, this.extensionsRegistry, initContext);
    return {
      getExtensionsRegistry: () => this.extensionsRegistry
    };
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.EsqlServerPlugin = EsqlServerPlugin;