"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _i18n = require("@kbn/i18n");
var _complete_items = require("../../complete_items");
var _factories = require("../../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest({
  innerText
}) {
  // SHOW INFO /
  if (/INFO\s+$/i.test(innerText)) {
    return [{
      ..._complete_items.pipeCompleteItem,
      command: _factories.TRIGGER_SUGGESTION_COMMAND
    }];
  }
  // SHOW LOLZ /
  else if (/SHOW\s+\S+\s+$/i.test(innerText)) {
    return [];
  }
  // SHOW /
  return [{
    text: 'INFO',
    detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.show.info.detail', {
      defaultMessage: 'Get information about the Elasticsearch cluster.'
    }),
    kind: 'Method',
    label: 'INFO'
  }];
}